//
// Copyright (c) 2006 Tobi Schäfer
// Alle Rechte vorbehalten. All rights reserved.
//
// $Revision: 427 $
// $Author: tobi $
// $Date: 2006-10-01 19:14:28 +0200 (So, 01 Okt 2006) $
//

app.addRepository("modules/core/Global")
app.addRepository("modules/core/String");

var Rabbit = function(restricted) {
   var self = this;
   var db, meta;
  
   var TYPE = "type.properties";
   var METAFILE = app.dir + "/.rabbit";
   var INFO = "log";

   var log = function(msg, level) {
      if (msg) {
         var lines = msg.split("\n"), m;
         for (var i in lines) {
            (m = lines[i]) && app[level || "debug"](m);
         }
      }
      return;
   };

   var sql = function(s) {
      log("Rabbit SQL: " + s);
      try {
         db.execute(s);
      } catch (e) {
         log(e.toString());
      }
      return;
   }

   var saveMeta = function() {
      /* FIXME: serialize does not work here, why?
      if (meta) {
         serialize(meta, METAFILE);
      }
      */
      var file = new File(METAFILE);
      file.remove();
      file.open();
      file.write(meta.toSource());
      file.close();
      return;
   };

   var loadMeta = function() {
      /* FIXME: serialize does not work here (see saveMeta), why?
      try {
         return deserialize(METAFILE);
      } catch (e) {
         return new Object;
      }
      */
      var file = new File(METAFILE);
      meta = eval(file.readAll());
      return;
   };
   
   var createTable = function(name) {
      var column = getColumnName(name, "id");
      sql("create cached table " + getTableName(name) + " (" + column + " " + getSqlType(Rabbit.TEXT) + " not null)");
      return column;
   };
   
   var addColumn = function(prototype, property, type) {
      var column = getColumnName(prototype, property);
      sql("alter table " + getTableName(prototype) + " add column " + column + " " + getSqlType(type));
      return column;
   };

   var dropColumn = function(prototype, property) {
      sql("alter table " + getTableName(prototype) + " drop column " + getColumnName(prototype, property));
      return;
   };
   
   var getTableName = function(prototype) {
      return "T_" + prototype.toUpperCase();
   };
   
   var getColumnName = function(prototype, property) {
      return (prototype + "_" + property).toUpperCase();
   };
   
   var getSqlType = function(type) {
      switch (type) {
         case Rabbit.NUMBER:
            return "numeric";
         case Rabbit.DATE:
            return "timestamp";
         case Rabbit.FILE:
         case Rabbit.IMAGE:
           return "longvarchar";
      }
      return "varchar";
   };

   var getDir = function(prototype) {
      return app.dir + "/" + prototype;
   };
   
   var getHeader = function(prefix) {
      return prefix + " generated by Rabbit on \n" + prefix + " " + new Date + "\n";
   };
   
   var getCollectionName = function(prototype) {
      return prototype.toLowerCase() + "s";
   };
   
   var checkProperty = function(property) {
      return !property.startsWith("_") &&
             !property.startsWith("rabbit");
   };
   
   var checkValue = function(value) {
      return !/object ?\(/.test(value) && 
             !/collection ?\(/.test(value) &&
             !/mountpoint ?[(]/.test(value); // FIXME: variation of syntax to fix highlighting in TextMate
   };
   
   this.init = function() {
      loadMeta();

      var driver = getProperty("rabbit.driver", "org.hsqldb.jdbcDriver")
      java.lang.Class.forName(driver).newInstance();

      var dir = new java.io.File(app.dir, "hsql.db/db");
      var database = getProperty(
         "rabbit.database", 
         "jdbc:hsqldb:file:" + dir.getCanonicalPath()
      );
      var user = getProperty("rabbit.user", "sa");
      var password = getProperty("rabbit.password", "");

      var config = new Object; 
      config[app.name + ".url"]        = database.replace(/\\/g, "/"); // FIXME: windows path separators are causing an exception 
      config[app.name + ".driver"]     = driver;
      config[app.name + ".user"]       = user;
      config[app.name + ".password"]   = password;
      this.writePropertiesFile(app.dir, "db.properties", config); 

      var connection = java.sql.DriverManager.getConnection(database, user, password);
      db = connection.createStatement();
      return db;
   };

   this.reset = function(/* prototype names */) {
      meta || self.init();
      var i, list;
      if (arguments.length > 0) {
         list = {};
         for (i=0; i<arguments.length; i+=1) {
            list[arguments[i]] = true;
         }
      } else {
         list = meta;
      }
      for (i in list) {
         sql("drop table " + getTableName(i) + " if exists cascade");
      }
      meta = {};
      saveMeta();
      app.clearCache();
      return;
   };
 
   this.setup = function(prototype, map) {
      meta || self.init();
      var name = prototype;

      // Do not create tables etc. for root
      if (name.toLowerCase() != "root") {
         var value;
         var current = self.readPropertiesFile(getDir(name), TYPE);
         for (var property in current) {
            value = map[property];
            if (checkProperty(property) && !value) {
               dropColumn(name, property);
            }
         }   
         if (!map._db) {
            map._db = app.name;
         }
         if (!map._table) {
            map._table = getTableName(name);
         }  
         map._id = createTable(name);
         map.rabbit = "mountpoint(PropertyMgr)";
         map.rabbit_xml = addColumn(name, "rabbit_xml", "longvarchar");
      }

      for (var property in map) {
         value = map[property];
         if (checkValue(value) && checkProperty(property)) {
            self.setMeta(name, property, value);
            map[property] = addColumn(name, property, value);
         } else if (property.endsWith(".accessname")) {
            // Determining prototype and table column from accessname setting
            var parts = /collection\s*\(\s*([^)]+)\s*\)/.exec(map._children);
            var childProto = parts[1];
            if (childProto) {
               map[property] = getColumnName(childProto, value);
            }
         }
      }

      saveMeta();
      self.writePropertiesFile(getDir(name), TYPE, map);
      return;
   };
   
   this.getMeta = function(prototype, property) {
      meta || self.init();
      var p = meta[prototype];
      return p && p[property];
   };
   
   this.setMeta = function(prototype, property, value) {
      meta || self.init();
      var p = meta[prototype];
      if (!p) {
         meta[prototype] = {};
      }
      meta[prototype][property] = value;
      return;
   }

   this.getSetup = function(object) {
      meta || self.init();
      return meta[object._prototype];
   };
   
   this.readPropertiesFile = function(dir, name) {
      var data = {};
      var file = new File(dir, name);
      if (file.exists()) {
         var content = file.readAll();
         var line, pairs;
         var parts = content.split("\n");
         for (var i in parts) {
            line = parts[i].trim();
            if (line && !line.startsWith("#")) {
               pairs = line.split("=");
               data[pairs[0].trim()] = pairs[1].trim();
            }
         }
      }
      return data;
   };

   this.writePropertiesFile = function(dir, name, data) {
      var content = new String;
      if (data) {
         for (var i in data) {
            content += i + " = " + data[i] + "\n";
         }
         var file = new File(dir, name);
         file.mkdir();
         file.remove();
         file.open();
         file.writeln(getHeader("##"));
         file.write(content);
         file.close();
      }
      return content;   
   };

   this.update = function(object, data) {
   	var setup = self.getSetup(object);
   	var property, value, type, contentType;
      for (property in setup) {
         value = data[property];
         type = self.getMeta(object._prototype, property);
         switch (type) {
            case Rabbit.DATE:
               var i, key, d = {};
               for (i in data) {
                  if (i.startsWith(property + ".")) {
                     key = i.split(".")[1];
                     d[key] = data[i];
                  }
               }
               value = new Date(d.y, d.M-1, d.d, d.H, d.m, d.s);
               break;
            case Rabbit.NUMBER:
               value = !isNaN(value) ? value : null;
               break;
            case Rabbit.FILE:
               if (value && value.content) {
                  contentType = value.contentType;
                  var base64 = new Packages.sun.misc.BASE64Encoder();
                  value = base64.encode(value.content) || null;
               }
               break;
         }
         if ((value = object.onSetProperty(property, value)) !== null) {
            object[property] = value;
            if (contentType) {
               object.rabbit.setProperty(property + ":type", contentType);
            }
         }
      }
      return;
   };

   this.editor = function(object) {
      self.snippet("layout:header");
      var setup = self.getSetup(object);
      var property, value, type;
      for (property in setup) {
         value = object[property];
         type = self.getMeta(object._prototype, property);
         switch (type) {
            case Rabbit.DATE:
               if (value === null) {
                  value = new Date;
               }
               value = Rabbit.dateEditor(property, value, new String);
               break;
            case Rabbit.FILE:
               value = self.snippet("html:upload", {
                  name: property
               }, new String);
               break;
            default:
               value = self.snippet("html:textarea", {
                  type: "text",
                  name: property,
                  value: (value === null) ? "" : value
               }, new String);
         }
         self.snippet("layout:property", {
            name: property.titleize(),
            value: value
         }, "properties");
      }
      self.snippet("layout:editor");
      self.snippet("layout:footer");
      return;

   };

   this.viewer = function(object) {
      self.snippet("layout:header");
      var setup = self.getSetup(object);
      var property, value, type;
      for (property in setup) {
         value = object[property];
         type = self.getMeta(object._prototype, property);
         switch (type) {
            case Rabbit.DATE:
               value = value.format(Rabbit.DATEFORMAT);
               break;
            case Rabbit.NUMBER:
               value = value.format("0.##");
               break;
            case Rabbit.FILE:
               value = self.snippet("html:link", {
                  href: object.href("." + property),
                  text: object.getContentType(property)
               }, new String);
               break;
            default:
               if (value === null) {
                  value = "";
               }
         }
         self.snippet("layout:property", {
            name: property.titleize(),
            value: value
         }, "properties");
      }
      self.snippet("layout:viewer");
      self.snippet("layout:footer");
      return;
   };

   this.getChildElement = function(obj) {
      var prototype = global[obj.substring(1)];
      if (prototype && prototype != Root) {
         var target = new prototype;
         if (req.data["rabbit"]) {
            self.update(target, req.data);
            this.add(target);
            res.redirect(target.href());
         }
         self.editor(target);
         return new HopObject;
      }
   };

   this.snippet = function(name, param, buffer) {
      var append = function(str) {
         // Do not create a handler for empty String objects
         if (buffer.length === 0) {
            return str;
         }
         if (!res.handlers.rendered) {
            res.handlers.rendered = new Object;
         }
         if (!res.handlers.rendered[buffer]) {
            res.handlers.rendered[buffer] = "";
         }
         return res.handlers.rendered[buffer] += str;
      };

      var DELIMITER = ":";
      var prefix = "Rabbit snippet: ";

      buffer && res.push();
      if (!name.contains(DELIMITER)) {
         log("Rabbit skin: " + name);
         renderSkin(name, param);
      }

      var cache;
      if (!(cache = res.meta["rabbit:snippets"])) {
         cache = res.meta["rabbit:snippets"] = new Object;
      }
      if (cache[name]) {
         log(prefix + name + " (cached)");
         renderSkin(cache[name], param);
         return buffer && append(res.pop());
      }

      var NAME = "snippet";
      var EXTENSION = "." + NAME + "s";
      var PREFIX = "<!" + NAME + DELIMITER;

      var parts = name.split(DELIMITER);
      var skin = app.skinfiles.Global["rabbit." + parts[0] + EXTENSION];
      var snippetName = parts[1];

      if (skin) {
         if (snippetName) {
            var needle = PREFIX + snippetName;
            var offset = skin.indexOf(needle);
            if (offset < 0) {
               return;
            }
            var start = offset + needle.length + 1;
            var end = skin.indexOf(PREFIX, start);
            if (end < 0) {
               end = skin.length;
            }
            var snippet = skin.substring(start, end);
            if (snippet) {
               log(prefix + name);
               cache[name] = createSkin(snippet.trim());
               renderSkin(cache[name], param);
            }
         }
      }

      return buffer && append(res.pop());
   };

   this.registerGlobals = function() {
      HopObject.prototype.getChildElement = function(obj) {
         if (obj.startsWith(" ")) {
            return self.getChildElement.call(this, obj);
         }
         if (obj.startsWith(".")) {
            return Rabbit.property.call(this, obj);
         }
         return this.get(obj);
      };

      HopObject.prototype.main_action = function() {
         // Only create viewers for custom prototypes
         if (this._prototype != "HopObject" && this != root) {
            self.viewer(this);
         }
         return; 
      };

      HopObject.prototype.edit_action = function() {
         if (req.data["rabbit"]) {
            self.update(this, req.data);
            res.redirect(this.href());
         }
         self.editor(this);
         return; 
      };

      global.resetPrototypes = self.reset;
      global.registerPrototype = self.setup;
      global.render = self.snippet;
      
      var statics = ["number", "text", "email", "date", "file", "image"];
      var i, s;
      for (i in statics) {
         s = statics[i].toUpperCase();
         global[s] = Rabbit[s];
      }
      return;
   };

   if (!restricted) {
      self.registerGlobals();
   }

   return this;
};

Rabbit.NUMBER  = 1;
Rabbit.TEXT    = 2;
Rabbit.EMAIL   = 3
Rabbit.DATE    = 4;
Rabbit.FILE    = 5;
Rabbit.IMAGE   = 6;

Rabbit.DATEFORMAT = "d. MMM. yyyy, HH:mm:ss'h'";

Rabbit.property = function(obj) {
   var property = obj.substring(1);
   var content = this[property];
   if (content) {
      res.contentType = this.getContentType(property);
      var parts = res.contentType && res.contentType.split("/");
      if (parts[0].startsWith("application")) {
         var servlet = res.getServletResponse();
         servlet.setHeader(
            "Content-disposition", 
            "attachment; filename=" + property + "." + parts[1]
         );
      }
      var base64 = new Packages.sun.misc.BASE64Decoder();
      res.writeBinary(base64.decodeBuffer(content));
   }
   return new HopObject;
};

Rabbit.chooserAsString = function() {
   res.push();
   Herpse.chooser.apply(this, arguments);
   return res.pop();
};

Rabbit.chooser = function(name, options, selected) {
   if (typeof options != "object") {
      return;
   }
   res.push();
   var value;
   for (var i in options) {
      value = options[i];
      self.snippet("html:option", {
         name: i,
         text: value,
         selected: (selected && value == selected) ? "selected" : ""
      });
   }
   self.snippet("html:chooser", {
      name: name,
      options: res.pop()
   });
   return;
};

Rabbit.dateEditor = function(name, date, buffer) {
   function range(start, stop, step) {
      var result = [];
      if (!step) {
         step = 1;
         if (!stop) {
            stop = start - 1;
            start = 0;
         }
      }
      for (var i=start; i<=stop; i+=step) {
         result.push(i);
      }
      return result;
   }

   buffer && res.push();
   Rabbit.chooser(name + ".d", range(1, 31), date.getDate());
   Rabbit.chooser(name + ".M", range(1, 12), date.getMonth() + 1);
   Rabbit.chooser(name + ".y", range(1900, 2099), date.getFullYear());
   Rabbit.chooser(name + ".H", range(0, 23), date.getHours());
   var fifty9 = range(0, 59);
   Rabbit.chooser(name + ".m", fifty9, date.getMinutes());
   Rabbit.chooser(name + ".s", fifty9, date.getSeconds());
   return buffer && res.pop();
};
